﻿using System.Collections.Generic;

namespace Microscopic_Traffic_Simulator___Model.CellularTopologyObjects.CellWalkers
{
    /// <summary>
    /// Class wrapping a cell walker and applying limit to number of walked cells but if wrapped
    /// cell walker returns less number than limit the nulls are returned until the 
    /// limit is reached.
    /// </summary>
    class LimitedMinimumStepsCellWalker : LimitedStepsCellWalker
    {
        /// <summary>
        /// The last cell which was walked.
        /// </summary>
        private Cell lastCell;
        /// <summary>
        /// The last cell which was walked.
        /// </summary>        
        internal Cell LastCell { get { return lastCell; } }

        /// <summary>
        /// Constructor of cell walker with limited number of walked cells or nulls.
        /// </summary>
        /// <param name="cellWalker">Cell walker to be wrapped.</param>
        /// <param name="max">Maximum number of walked cells.</param>
        internal LimitedMinimumStepsCellWalker(CellWalker cellWalker, int max) :
            base(cellWalker, max) { }

        /// <summary>
        /// Get walked cells or nulls whose number is at most 'max'.
        /// </summary>
        /// <returns>Walked cells.</returns>
        internal override IEnumerable<Cell> GetNext()
        {
            foreach (Cell cell in base.GetNext())
            {
                lastCell = cell;
                yield return cell;
            }
            while (i-- > 0)
            {
                yield return null;
            }
        }
    }
}
